function save_plot(varargin)
%a little function that pulls up a gui that helps you save the current plot
%as a graphics file
%syntax: save_plot(handle)
%input: handle = handle of the figure of axis you want to save as an image.
%           if you leave the parameter empty, the function will select the
%           axis in focus.
%output: none - other than the file of course.

if isempty(varargin)
    h = gca;    %get current figure handle
elseif ishandle(varargin{1,1})
    h = varargin{1,1};
else
    error(['Error: save_plot only takes one input, and it must be the handle of a graphics object.']);
end

%get location, name and format
[filename, pathname, filterindex] = uiputfile( ...
{'*.jpg','JPEG (invalid for Simulink models)';
 '*.tif', 'TIFF image, compressed'; ...
 '*.bmp','Windows bitmap'; ...
 '*.ai','Adobe Illustrator `88'; ...
 '*.eps','EPS Level 1'; ...
 '*.png','Portable Network Graphics';...
 '*.m','M-file (invalid for Simulink models)';...
 '*.*',  'All Files (*.*)'}, ...
 'Save Current Plot...');
if ~isequal(filename,0) && ~isequal(pathname,0)   %user did not press cancel
    %parse type
    switch filterindex
        case 1  %jpeg
            format = 'jpg';
        case 2  %tif
            format = 'tif';
        case 3  %bmp
            format = 'bmp';
        case 4  %ai
            format = 'ai';
        case 5  %eps
            format = 'eps';
        case 6  %png
            format = 'png';
        case 7  %m
            format = 'm';
    end

    %save file
    snap_shot = getframe;
    imwrite(snap_shot(1).cdata,[pathname,filename],format);
    %saveas(h,[pathname,filename],format)   %not quite up to task.
end